<?php
require __DIR__.'/db.php';
agent_require_login();
$login = $_SESSION['agent_login'];
$pdo = pdo();
// Barrido de inactivos (opcional)
$pdo->exec("UPDATE mesacontrol_agente_estado SET estado='logout', is_active=0 WHERE is_active=1 AND TIMESTAMPDIFF(SECOND,last_seen,NOW())>120");

$stmt = $pdo->prepare("SELECT estado, last_change, last_seen FROM mesacontrol_agente_estado WHERE login=?");
$stmt->execute([$login]);
$est = $stmt->fetch() ?: ['estado'=>'logout','last_change'=>null,'last_seen'=>null];
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Mesa de Control — Estado de Agente</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Lato:wght@400;700&display=swap" rel="stylesheet">
<style>
  body{font-family:'Lato',Arial,sans-serif;background:#f7f8fa;margin:0}
  .nav{display:flex;justify-content:space-between;align-items:center;padding:12px 16px;background:#101828;color:#fff}
  .wrap{max-width:980px;margin:18px auto;background:#fff;border:1px solid #e6e7ea;border-radius:12px;padding:18px}
  .grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(140px,1fr));gap:12px}
  .btn{padding:12px;border:1px solid #d0d5dd;border-radius:10px;background:#f8fafc;font-weight:700;cursor:pointer}
  .btn:hover{background:#eef2f7}
  .badge{display:inline-block;padding:6px 10px;border-radius:999px;background:#eef4ff;color:#1b4fd1;font-weight:700}
  .danger{background:#fee4e2;color:#b42318}
  .meta{color:#667085;font-size:.9em}
</style>
</head>
<body>
  <div class="nav">
    <div><strong><?php echo htmlspecialchars($_SESSION['agent_name']); ?></strong> (<code><?php echo htmlspecialchars($login); ?></code>)</div>
    <div>
      <a href="hard_logout.php" class="btn" style="text-decoration:none;color:#101828;background:#ffece9;border-color:#ffc4b8">Salir</a>
    </div>
  </div>

  <div class="wrap">
    <h2>Mi estado actual: <span id="estado" class="badge"><?php echo htmlspecialchars($est['estado']); ?></span></h2>
    <p class="meta">Último cambio: <span id="last_change"><?php echo htmlspecialchars($est['last_change'] ?? '—'); ?></span> · Último latido: <span id="last_seen"><?php echo htmlspecialchars($est['last_seen'] ?? '—'); ?></span></p>

    <div class="grid" style="margin-top:12px">
      <button class="btn" data-s="disponible">Disponible</button>
      <button class="btn" data-s="pausa">Pausa</button>
      <button class="btn" data-s="baño">Baño</button>
      <button class="btn" data-s="comida">Comida</button>
      <button class="btn" data-s="entrenamiento">Entrenamiento</button>
      <button class="btn danger" id="logout">Logout</button>
    </div>

    <p class="meta" style="margin-top:16px">Esta página no caduca: mientras permanezca abierta se envía un <em>heartbeat</em> cada 20s. Si se cierra la pestaña/ventana o se cae el navegador, el sistema intenta marcar <strong>logout</strong> automáticamente; si no alcanza a enviar, el evento/guard de inactividad lo hará en ~2 minutos.</p>
  </div>

<script>
const $estado = document.getElementById('estado');
const $lastChange = document.getElementById('last_change');
const $lastSeen = document.getElementById('last_seen');

async function postJSON(url, data){
  const res = await fetch(url, {method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(data)});
  if(!res.ok) throw new Error(await res.text());
  return res.json();
}

async function setEstado(estado){
  try{
    const r = await postJSON('api_state.php', {estado});
    $estado.textContent = r.estado;
    $lastChange.textContent = r.last_change;
    $lastSeen.textContent = r.last_seen;
  }catch(e){ console.error(e); }
}

async function heartbeat(){
  try{
    const r = await postJSON('api_heartbeat.php', {});
    $lastSeen.textContent = r.last_seen;
  }catch(e){ console.warn('HB error', e); }
}

// UI handlers
for (const btn of document.querySelectorAll('.btn[data-s]')){
  btn.addEventListener('click', ()=> setEstado(btn.dataset.s));
}

document.getElementById('logout').addEventListener('click', async ()=>{
  try { await postJSON('api_logout.php', {}); } catch {}
  location.href = 'login.php';
});

// Heartbeat cada 20 s
const hb = setInterval(heartbeat, 20000);
heartbeat(); // primer latido inmediato

// Intentar marcar logout al cerrar/ocultar
function sendBeaconLogout(){
  try {
    const data = new Blob([JSON.stringify({reason:'pagehide'})], {type:'application/json'});
    navigator.sendBeacon('api_logout.php', data);
  } catch { /* ignore */ }
}

window.addEventListener('pagehide', sendBeaconLogout);
window.addEventListener('beforeunload', sendBeaconLogout);
document.addEventListener('visibilitychange', ()=>{
  if (document.visibilityState === 'hidden') sendBeaconLogout();
});
</script>
</body>
</html>
