<?php
require __DIR__.'/db.php';
header('Content-Type: application/json; charset=utf-8');
agent_require_login();
$login = $_SESSION['agent_login'];

$raw = file_get_contents('php://input');
$in = json_decode($raw, true) ?: [];
$estado = sanitize_state((string)($in['estado'] ?? 'disponible'));

try {
  agent_upsert_state($login, $estado, $estado !== 'logout', session_id());
  $pdo = pdo();
  $stmt = $pdo->prepare("SELECT estado, last_change, last_seen FROM mesacontrol_agente_estado WHERE login=?");
  $stmt->execute([$login]);
  $row = $stmt->fetch();
  echo json_encode(['ok'=>true] + $row);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'msg'=>$e->getMessage()]);
}
