<?php
require __DIR__.'/db.php';
header('Content-Type: application/json; charset=utf-8');
agent_require_login();
$login = $_SESSION['agent_login'];

try {
  agent_touch_seen($login);
  $pdo = pdo();
  $stmt = $pdo->prepare("SELECT last_seen FROM mesacontrol_agente_estado WHERE login=?");
  $stmt->execute([$login]);
  $row = $stmt->fetch();
  echo json_encode(['ok'=>true,'last_seen'=>$row['last_seen'] ?? date('Y-m-d H:i:s')]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'msg'=>$e->getMessage()]);
}
